#ifndef _HEADERS_DEFINITIONS_H
#define _HEADERS_DEFINITIONS_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define TitleCaption "SQL-Exchange Client"
#define FileVersion  "1.0.0.0"
#define RegistryKey  "Software\\Enginuity\\SQL-Exchange\\Client"  

#define AUTH_CMD_FAILED     1
#define AUTH_CMD_OK         2
#define AUTH_CMD_SUCCESS    3
#define AUTH_CMD_DISCONNECT 4
#define AUTH_CMD_UNKNOWN    5

#define COMMAND_RESULT_DISCONNECT 1
#define COMMAND_RESULT_OK         2
#define COMMAND_RESULT_ERROR      3
#define COMMAND_RESULT_UNKNOWN    4

//---------------------(Instance Definitions & Dialog Handle Definitions)
HINSTANCE MainInstance = NULL; // WinMain (Application) Instance
HWND MainDialog_hWnd   = NULL;

//---------------------(Global Variables)
char gsBaseCommKey[1024];

char gsAuthString[1024]; 
char gsCompanyName[64];        
char gsCompanyPassword[64];    

char gsSQLServer[255];
char gsSQLUserID[255];
char gsSQLPassword[255];
char gsSQLDatabase[255];
char gsSQLDriver[255];

char gsWPServer[255];

DWORD dlDataCRC = 0;
DWORD glConnectPort = 0;
DWORD glTCPLoopDelay = 0;

DWORD WINAPI Client_Thread(LPVOID);
DWORD Client_Thread_ID = 0;
HANDLE Client_Thread_Handle = NULL;

struct _MainDialogInfo{
    HWND RecvEdit_hWnd;
}; _MainDialogInfo MDI;

_QueuSystem QS;

//---------------------(Dialog Prototypes)
BOOL CALLBACK MainDialog(HWND, UINT, WPARAM, LPARAM);

//---------------------(Function Prototypes)
bool DoConnect(void);
bool DoDisconnect(void);

int AuthenticateWithServer(void);

bool ClientSend(char *, int);
bool SimpleClientSend(char *);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif



